/* Diese Klasse ist auch als Interface realisierbar. 
 * Da Interfaces erst in der nächsten VL vorkommen,
 * hier als abstrakte Klasse umgesetzt.
 */
public abstract class Geoobjekt{
  /**
   * Methode zur Berechnung, ob ein &uuml;bergebener Punkt
   * sich in diesem Objekt befindet, der Rand soll dabei 
   * zum Objekt gehören.
   * 
   * @param p
   *          zu untersuchender Punkt
   * @return Punkt liegt im betrachteten Objekt
   */
    public abstract boolean innerhalb(Punkt p);  
    
  /**
   * Methode zum Verschieben des Objektes, dabei wird
   * das gesamte Objekt auf der x-Achse um dx Punkte
   * und auf der y-Achse um dy-Punkte verschoben.
   * 
   * @param dx
   *          Verschiebung auf der x-Achse
   * @param dy
   *          Verschiebung auf der y-Achse
   */  
    public abstract void verschieben(int dx, int dy);
    
  /**
   * Methode zur Berechnung der linken-oberen Ecke des
   * Objektes, dabei kann kein Punkt des Objektes sich
   * weiter links oder oberhalb dieses Punktes befinden.
   * 
   * @return linke-obere Begrenzung der Figur
   */
    public abstract Punkt linksoben();

  /**
   * Methode zur Berechnung der rechten-unteren Ecke des
   * Objektes, dabei kann kein Punkt des Objektes sich
   * weiter rechts oder unterhalb dieses Punktes befinden.
   * 
   * @return rechte-untere Begrenzung der Figur
   */    
    public abstract Punkt rechtsunten();
    
  /**
   * Methode zum Zeichen des Objekts auf einem
   * Interaktionsbrettobjekt, dabei wird das Objekt
   * komplett schwarz dargestellt.
   * 
   * @param ib
   *          Interaktionsbrett, auf dem gezeichnet werden soll
   */
    public abstract void darstellen(Interaktionsbrett ib);
}
