import org.junit.Assert;
import org.junit.Test;

public class TippTest {
	private Tipp t1 = new Tipp();
	private Tipp t2 = new Tipp();
	
	@Test
	public void testUnterschiedlicheWerte(){
		for(int i=0; i<100; i=i+1){
			unterschiedlich(new Tipp());
		}
	}
	
	private void unterschiedlich(Tipp tip){
		int inhalt[] = tip.getWerte();
		for(int i=0; i<inhalt.length-1; i=i+1){
			Assert.assertTrue(inhalt[i]>0 && inhalt[i]<50);
			for(int j=i+1; j<inhalt.length; j=j+1){
				Assert.assertTrue(!(inhalt[i] == inhalt[j]));
			}
		}
	}
	
	@Test
	public void testNuller(){
		t1.setWerte(new int[]{1,2,3,4,5,6});
		t2.setWerte(new int[]{11,12,13,14,15,16});
		Assert.assertTrue(t1.gemeinsam(t2) == 0);
	}
	
	@Test
	public void testEiner(){
		t1.setWerte(new int[]{1,12,3,24,5,36});
		t2.setWerte(new int[]{31,12,43,4,15,46});
		Assert.assertTrue(t1.gemeinsam(t2) == 1);
	}
	
	@Test
	public void testZweier(){
		t1.setWerte(new int[]{1,12,3,24,5,36});
		t2.setWerte(new int[]{31,12,43,4,15,36});
		Assert.assertTrue(t1.gemeinsam(t2) == 2);
	}
	
	@Test
	public void testDreier(){
		t1.setWerte(new int[]{1,12,43,24,5,36});
		t2.setWerte(new int[]{31,12,43,4,15,36});
		Assert.assertTrue(t1.gemeinsam(t2) == 3);
	}
	
	@Test
	public void testVierer(){
		t1.setWerte(new int[]{4,12,43,24,5,36});
		t2.setWerte(new int[]{31,12,43,4,15,36});
		Assert.assertTrue(t1.gemeinsam(t2) == 4);
	}
	
	@Test
	public void testFuenfer(){
		t1.setWerte(new int[]{4,12,43,24,5,36});
		t2.setWerte(new int[]{31,12,43,4,24,36});
		Assert.assertTrue(t1.gemeinsam(t2) == 5);
	}
	
	@Test
	public void testSechser(){
		t1.setWerte(new int[]{4,12,43,24,36,31});
		t2.setWerte(new int[]{31,12,43,4,24,36});
		Assert.assertTrue(t1.gemeinsam(t2) == 6);
	}

}
