import java.util.ArrayList;


public class Arena {
	private ArrayList<KaempferInterface> gegner 
	                    = new ArrayList<KaempferInterface>();
	private Kaempfer held;
	
	public Kaempfer kaempferErstellen(){
		Integer punkte = 30;
		EinUndAusgabe io = new EinUndAusgabe();
		io.ausgeben("Teilen Sie "+punkte 
				+ " in Kraft und Geschick auf:\n"
				+ "Kraft (1-"+(punkte-1)+"): ");
		Integer kraft=0;
		while (kraft<1 || kraft>punkte-1){
			kraft = io.leseInteger();
		}
		return new Simplo("Isch",500,kraft,30-kraft);
	}
	
	public KaempferInterface kaempfen(KaempferInterface k1, KaempferInterface k2){
		while(k1.getGesundheit()>0 && k2.getGesundheit()>0){
			ersterHautZweiter(k1,k2);
			if(k2.getGesundheit()>0){
				ersterHautZweiter(k2,k1);
			}
		}
		if(k1.getGesundheit()>=0)
			return k1;
		return k2;
	}
	
	private void ersterHautZweiter(KaempferInterface k1, KaempferInterface k2){
		EinUndAusgabe io = new EinUndAusgabe();
		io.ausgeben(k1.getName()+" haut zu.\n");
		Integer schaden = k2.einstecken(k1.angreifen());
		io.ausgeben(k2.getName()+" verliert "+schaden+" Punkte.\n");
		io.ausgeben(k1.getName()+" hat "+k1.getGesundheit()
				+" Punkte, "+k2.getName()+ " hat "
				+k2.getGesundheit()+" Punkte.\n*****\n");
	}
	
	public void gegnerErstellen(){
		gegner.add(new Nerdo("Ulf",100,3,3));
		gegner.add(new Simplo("Uta",200,6,6));
		gegner.add(new Simplo("Urs",300,9,9));
		gegner.add(new Hulko("Ute",100));
	}
	
	public void kampfOrganisieren(){
		EinUndAusgabe io = new EinUndAusgabe();
		this.held = kaempferErstellen();
		gegnerErstellen();
		while(held.getGesundheit()>0 && gegner.size()>0){
			KaempferInterface herausforderer = gegner.get(0);
			KaempferInterface sieger = kaempfen(held,herausforderer);
			if (held.equals(sieger)){
				gegner.remove(0);
			}
		}
		if(held.getGesundheit()>0){
			io.ausgeben("Sie haben glorreich gewonnen.\n");
		} else {
			io.ausgeben("Sie haben schmachvoll verloren.\n");
		}
		
	}


	public static void main(String[] args) {
		new Arena().kampfOrganisieren();

	}

}
