import java.util.ArrayList;

public class ComputerSpieler implements SpielerInterface{

  private ArrayList<Item> items;
  private int schritte = 0;

  public ComputerSpieler() {
    this.items = new ArrayList<Item>();
    this.items.add(new Pilz());
  }

  public int handeln(ArrayList<HaendlerInterface> hand
  , EinUndAusgabe io){
    if (this.items.size() == 0 || this.schritte >= 5000) {
      return 0;
    }
    this.schritte++;
    int pilzAn = this.suchePositionPilz();
    if (pilzAn >= 0) {
      Item tauschen = this.items.get(pilzAn);
      this.items.remove(pilzAn);
      HaendlerInterface bekommtPilz = this.sucheHaendler(hand, Zwerg.class);
      if (bekommtPilz == null) {
        bekommtPilz = this.sucheHaendler(hand, Zauberer.class);
        //io.ausgeben(this.schritte + " C: " + this.items + "\n");
        return 1; 
      }
      if (bekommtPilz != null) {
        this.items.addAll(bekommtPilz.handel(tauschen));
      }
    }

    HaendlerInterface zocker = this.sucheHaendler(hand, Zocker.class);
    if (zocker == null) {
      return 0;
    }
    Item tauschen = this.items.get(0);
    this.items.remove(0);
    this.items.addAll(zocker.handel(tauschen));
    //io.ausgeben(this.schritte + " C: " + this.items + "\n");
    return 1;    
  }

  private int suchePositionPilz(){
    for (int i = 0; i < this.items.size(); i++) {
      if (this.items.get(i).getClass() == Pilz.class){
        return i;
      }
    }
    return -1;
  }

  private HaendlerInterface sucheHaendler(ArrayList<HaendlerInterface> hand,Class clazz){
    for (int i = 0; i < hand.size(); i++) {
      if (hand.get(i).getClass() == clazz){
        return hand.get(i);
      }
    }
    return null;
  }

  public int getSchritte(){
    return this.schritte;
  }
}
