public class CoinAnalyse {
    private enum CoinColor { COPPER, NICKEL, SILVER }
    
    public static void main(String[] args) {  
        for (Coin c : Coin.values()){   
            System.out.println(c +":"+c.value()+"c "+color(c));
        }
    }
    
    private static CoinColor color(Coin c) {
        switch(c) {
            case PENNY: 
                return CoinColor.COPPER;   
            case NICKEL: 
                return CoinColor.NICKEL;   
            case DIME: 
            case QUARTER: 
                return CoinColor.SILVER;
            default: 
                throw new AssertionError("Unknown coin: " + c);
        }  
    } 
}
