public class Punkt { //implements Cloneable{
    private int x;
    private int y;

    public Punkt(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Punkt(Punkt other){
        this.x = other.getX();
        this.y = other.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public String toString(){
        return "["+this.x+","+this.y+"]";
    }

    @Override
    public int hashCode() {
        return this.x + (this.y * 33);
    }

    @Override
    public boolean equals(Object obj) {
        EinUndAusgabe io = new EinUndAusgabe();
        io.ausgeben("in equals(Object)\n");
        if (obj == null || !(obj instanceof Punkt)) {
            return false;
        }
        Punkt other = (Punkt) obj;
        return this.equals(other);
    }

    public boolean equals(Punkt other) {
        EinUndAusgabe io = new EinUndAusgabe();
        io.ausgeben("in equals(Punkt)\n");
        if (other == null) {
            return false;
        }
        return this.x == other.getX() && this.y == other.getY();
    }

    @Override
    public Punkt clone(){
        return new Punkt(this.x, this.y);
    }

}
