public class ExceptionAnalyse {
  public static void analyse(){
    String[] arr = {"Hallo"};
    // System.out.println(arr[1]);
    try {
      int eingabe = eingeben();
      System.out.println(eingabe);
    } catch (ArrayIndexOutOfBoundsException e) {
      System.out.println("ArrayException");
    } catch (NumberFormatException e) {
      System.out.println("NumberException");
    } catch (Nicht42 e) {
      System.out.println(e.getMessage());
    } catch (IllegalArgumentException e) {
      System.out.println(e.getMessage());
    }finally {
      System.out.println("Finally");
    }
    System.out.println("Schicht");
  }

  public static int eingeben() throws Nicht42 {
    System.out.println("Start");
    EinUndAusgabe io = new EinUndAusgabe();
    String eingabe = io.leseString();
    int ergebnis;
    ergebnis = Integer.decode(eingabe);
    if (ergebnis == 42){
      throw new Nicht42(); // checked
    }
    if (ergebnis == 41) {
      throw new IllegalArgumentException("auch nich 41"); 
    }
    System.out.println("Ende");
    return ergebnis;
  }
  
  public static int eingebenSinnvolleVariante(){
    EinUndAusgabe io = new EinUndAusgabe();
    String eingabe = io.leseString();
    int ergebnis;
    try { 
      ergebnis = Integer.decode(eingabe);
    } catch (NumberFormatException e){
      ergebnis = -1; 
    }
    return ergebnis;
  }
}
