package control;

import java.io.File;
import java.io.FileNotFoundException;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import entity.Student;
import entity.Austauschstudent;

public class StudentenverwaltungTest
{
    private Studentenverwaltung studis;
    private Student s1 =new Student("Uwe","X",1987,"IMI",424241);
    private Student s2 =new Austauschstudent("CHN","Xi","Yu",1988,"IMI",424242);
    private Student s3 =new Austauschstudent("USA","Mo","Jo",1989,"MID",424243);
    private Student s4 =new Student("Uta","B",1987,"MID",424244);

    @Before
    public void setUp(){
        studis = new Studentenverwaltung();
        studis.hinzufuegen(s1);
        studis.hinzufuegen(s2);
        studis.hinzufuegen(s3);
        studis.hinzufuegen(s4);
    }

    @Test
    public void testSuchenErfolgreich(){
        Assert.assertTrue(studis.studentSuchen(424242).equals(s2));
    }   

    @Test	
    public void testSuchenErfolglos1(){
        Assert.assertTrue(studis.studentSuchen(434242) == null);
    }

    @Test    
    public void testSuchenErfolglos2(){
        studis = new Studentenverwaltung();
        Assert.assertTrue(studis.studentSuchen(424242) == null);
    }

    @Test    
    public void testZaehlen1(){
        Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 2);
    }

    @Test    
    public void testZaehlen2(){
        Assert.assertTrue(studis.studentenZaehlenIn("MID") == 2);
    }

    @Test   
    public void testZaehlen3(){
        Assert.assertTrue(studis.studentenZaehlenIn("FBI") == 0);
    }

    @Test   
    public void testZaehlen4(){
        studis = new Studentenverwaltung();
        Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 0);
    }

    @Test
    public void testLoeschenErfolg(){
        studis.studentloeschen(424242);
        Assert.assertTrue(studis.studentSuchen(424242) == null);
        Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 1);
        Assert.assertTrue(studis.studentenZaehlenIn("MID") == 2);	
    }

    @Test
    public void testLoeschenNichtExistent(){
        studis.studentloeschen(414242);
        Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 2);
        Assert.assertTrue(studis.studentenZaehlenIn("MID") == 2);	
    }

    @Test
    public void testLoeschenExistierendenStudiengangs(){
        int anzahl = studis.studiengangLoeschen("MID");
        Assert.assertTrue(anzahl == 2);
        Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 2);
        Assert.assertTrue(studis.studentenZaehlenIn("MID") == 0);	
    }

    @Test
    public void testLoeschenNichtExistentenStudiengangs(){
        int anzahl = studis.studiengangLoeschen("ITI");
        Assert.assertTrue(anzahl == 0);
        Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 2);
        Assert.assertTrue(studis.studentenZaehlenIn("MID") == 2);	
    }

    @Test
    public void testAustauschstudentenZaehlen(){
        int anzahl = studis.anzahlAustauschstudenten();
        Assert.assertTrue(anzahl == 2);
    }
	
	@Test
	public void testPersistenz1(){
		try {
			studis.datenSpeichern("tmp.txt");
			studis.studiengangLoeschen("ITI");
			studis.studiengangLoeschen("MID");
			studis.datenLaden("tmp.txt");
			Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 2);
			Assert.assertTrue(studis.studentenZaehlenIn("MID") == 2);	
			File file = new File("tmp.txt");
			file.delete();
		} catch (FileNotFoundException e) {
			Assert.assertTrue("unerwartete Exception",false);
		}
	}
	
	@Test
	public void testPersistenz2(){
		try {
			File file = new File("tmp.txt");
			file.delete();
			studis.datenLaden("tmp.txt");
			Assert.assertTrue(false);
		} catch (FileNotFoundException e) {
			Assert.assertTrue(studis.studentenZaehlenIn("IMI") == 2);
			Assert.assertTrue(studis.studentenZaehlenIn("MID") == 2);	
		}
	}
}
