package entity;

public class Student{
    protected String vorname ="Eva";
    protected String nachname ="Mustermann";
    protected int geburtsjahr = 1990;
    protected String studiengang = "IMI";
    protected int matrikelnummer = 232323;
    
    public Student(String vorname, String nachname, 
            int geburtsjahr, String studiengang, 
            int matrikelnummer) {
        this.vorname = vorname;
        this.nachname = nachname;
        this.geburtsjahr = geburtsjahr;
        this.studiengang = studiengang;
        this.matrikelnummer = matrikelnummer;
    }
    
    public Student(){
        
    }
    
    /* schlechter erster Versuch
    void vertauscheNamen(){
        this.vorname = this.nachname;
        this.nachname = this.vorname;
    }
    */
   
    /* fuer Vererbunghsbeispiel */
    public int zaehlenAlsAustauschstudent(){
		return 0;
	}
    
    public void vertauscheNamen(){
        String tmp = this.vorname;
        this.vorname = this.nachname;
        this.nachname = tmp;
    }
    
    public String langnameBerechnen(){
        String ergebnis = this.studiengang;
        if(this.studiengang.equals("ITI")){
            ergebnis = "Informatik - Technische Informatik";
        }
        return ergebnis;
    }
    
    public String langnameBerechnen2(){
        String ergebnis = this.studiengang;
        if(this.studiengang.equals("ITI")){
            return "Informatik - Technische Informatik";
        }
        return ergebnis;
    }
    
    public String langnameBerechnen3(){
        if(this.studiengang.equals("ITI")){
            return "Informatik - Technische Informatik";
        }
        return this.studiengang;
    }
    
    public String langnameBerechnen4(){
        return this.studiengang.equals("ITI")
              ? "Informatik - Technische Informatik"
              : this.studiengang;         
    }
    
    public String persoenlichkeit(){
        String ergebnis;
        if(this.geburtsjahr < 1970){
            ergebnis = "alter Sack";
        } else {
            ergebnis = "Windelhopser";
        }
        return ergebnis;
    }
    
    public String genauerePersoenlichkeit(){
        String ergebnis;
        if(this.geburtsjahr < 1970){
            ergebnis = "alter Sack";
        } else {
            ergebnis = jungePersoenlichkeit();
        }
        return ergebnis;
    }
    
   public String genauerePersoenlichkeit2(){
        if(this.geburtsjahr < 1970){
            return "alter Sack";
        } 
        if (this.studiengang.equals("ITI")){
            return "Dynamit";
        } 
        return "Windelhopser";
    }
    
    public String genauerePersoenlichkeit3(){
        String ergebnis;
        if(this.geburtsjahr < 1970){
            ergebnis = "alter Sack";
        } else {
            ergebnis = this.jungePersoenlichkeit();
        }
        return ergebnis;
    }

    private String jungePersoenlichkeit() {
        String ergebnis;
        if (this.studiengang.equals("ITI")){
            ergebnis = "Dynamit";
        } else {
            ergebnis = "Windelhopser";
        }
        return ergebnis;
    }   

    
    public String genauerePersoenlichkeit4(){ 
        if (!(this.geburtsjahr < 1970) && this.studiengang.equals("ITI")){
            return "Dynamit";
        }
        if (!(this.geburtsjahr < 1970) && !this.studiengang.equals("ITI")){
            return "Windelhopser";
        } 
        return "alter Sack";
    }

    
    public void setVorname(String vorname) {
        if(vorname.equals("")) {
            this.vorname="<unbekannt>";
        } else {
            this.vorname = vorname;
        }
    }
    
    public boolean equals0(Student other){
        if (other == null){
            return false;
        }
        if (this.vorname.equals(other.getVorname())
                && this.nachname.equals(other.getNachname())
                && this.studiengang.equals(other.getStudiengang())
                && other.getGeburtsjahr() == this.geburtsjahr
                && other.getMatrikelnummer() == this.matrikelnummer){
            return true;
        }   
        return false;
    }
    
    public boolean equals(Student other){
         if (other == null){
              return false;
         }
        if (this.nachname == null) {
            if (other.getNachname() != null) {
                return false;
            }
        } else {
            if (!this.nachname.equals(other.getNachname())) {
                return false;
            }
        }
        if (this.studiengang == null) {
            if (other.getStudiengang() != null) {
                return false;
            }
        } else {
            if (!this.studiengang.equals(other.getStudiengang())) {
                return false;
            }
        }
        if (this.vorname == null) {
            if (other.getVorname() != null) {
                return false;
            }
        } else {
            if (!this.vorname.equals(other.getVorname())) {
                return false;
            }
        }
        return other.getGeburtsjahr()== this.geburtsjahr
        		&& other.getMatrikelnummer() == this.matrikelnummer;
    }
    
    public String toString(){
        return this.vorname+" "+this.nachname+" ("
            +this.matrikelnummer+"):"+this.studiengang;
        
    }
    
    
    
    //-- get- und set-Methoden



    public String getVorname() {
        return this.vorname;
    }
    
    /* alte set-Methode
    void setVorname(String vorname) {
        this.vorname = vorname;
    }
    */

    public String getNachname() {
        return this.nachname;
    }

    public void setNachname(String nachname) {
        this.nachname = nachname;
    }

    public int getGeburtsjahr() {
        return this.geburtsjahr;
    }

    public void setGeburtsjahr(int geburtsjahr) {
        this.geburtsjahr = geburtsjahr;
    }

    public String getStudiengang() {
        return this.studiengang;
    }

    public void setStudiengang(String studiengang) {
        this.studiengang = studiengang;
    }

    public int getMatrikelnummer() {
        return this.matrikelnummer;
    }

    public void setMatrikelnummer(int matrikelnummer) {
        this.matrikelnummer = matrikelnummer;
    }
    
}