package haendler;
import org.junit.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import java.util.ArrayList;
import items.Item;

// etwas grobe Beispieltests
public class HaendlerTest {
  private Beamter beamter = new Beamter();
  private Zocker zocker = new Zocker(null);
  private Zauberer zauberer = new Zauberer(null);
  private Zwerg zwerg = new Zwerg(null);

  @Test
  public void testBeamter(){
    Item item = Item.STEIN;
    ArrayList<Item> ergebnis = this.beamter.handel(item);
    Assert.assertEquals(1, ergebnis.size());
    Assert.assertSame(item, ergebnis.get(0));
  }
  
  @Test 
  public void testZocker(){
    ArrayList<Item> ergebnis = this.zocker.handel(Item.STEIN);
    Assert.assertTrue(ergebnis.size() <= 2);
  }
  
  @Test 
  public void testZaubererStein(){
    ArrayList<Item> ergebnis = this.zauberer.handel(Item.STEIN);
    Assert.assertEquals(1, ergebnis.size());
    Assert.assertSame(Item.TRANK, ergebnis.get(0));
  }
  
  @Test 
  public void testZaubererPilz(){
    ArrayList<Item> ergebnis = this.zauberer.handel(Item.PILZ);
    Assert.assertEquals(2, ergebnis.size());
    Assert.assertSame(Item.TRANK, ergebnis.get(0));
    Assert.assertSame(Item.TRANK, ergebnis.get(1));
  }
  
  @Test 
  public void testZaubererTrank(){
    ArrayList<Item> ergebnis = this.zauberer.handel(Item.TRANK);
    Assert.assertEquals(1, ergebnis.size());
    Assert.assertSame(Item.TRANK, ergebnis.get(0));
  }
  
  @Test 
  public void testZwergPilz(){
    ArrayList<Item> ergebnis = this.zwerg.handel(Item.PILZ);
    Assert.assertEquals(2, ergebnis.size());
    Assert.assertSame(Item.STEIN, ergebnis.get(0));
    Assert.assertSame(Item.STEIN, ergebnis.get(1));
  }
}
