package main;

import java.util.ArrayList;
import haendler.HaendlerInterface;
import haendler.Zwerg;
import haendler.Beamter;
import haendler.Zauberer;
import haendler.Zocker;
import spieler.SpielerInterface;
import spieler.Spieler;
import main.EinUndAusgabe;
import informanten.Informant;


public class Steuerung {

  private ArrayList<HaendlerInterface> haendler;
  private ArrayList<Informant> infos;
  
  public Steuerung() {
    this.haendler = new ArrayList<HaendlerInterface>();
    this.haendler.add(new Zwerg("Sergej"));
    this.haendler.add(new Beamter());
    this.haendler.add(new Zauberer("Achmed"));
    this.haendler.add(new Zocker("Laila"));
    this.infos = new ArrayList<Informant>();
    for(HaendlerInterface h: this.haendler) {
      if (h.getClass() != Beamter.class) {
        this.infos.add((Informant)h);
      }
    }
  }
  
  public void steuern() {
    EinUndAusgabe io = new EinUndAusgabe();
    io.ausgeben("Spielername: ");
    SpielerInterface spieler = new Spieler(io.leseString());
    //spieler = new ComputerSpieler();
    int ein = -1;
    while (ein != 0) {
      ein = spieler.handeln(this.haendler, io);
    }
    for (Informant inf: this.infos){
      io.ausgeben(inf.aktuelleInformationen() + "\n");
    }
  }
  
  public static void main(String[] s) {
    new Steuerung().steuern();
  }
}
