package spieler;

import java.util.ArrayList;
import items.Item;
import haendler.HaendlerInterface;
import main.EinUndAusgabe;

public class Spieler implements SpielerInterface{
  private String name;
  private ArrayList<Item> items;
  
  public Spieler(String name) {
    this.name = name;
    this.items = new ArrayList<Item>();
    this.items.add(Item.PILZ);
  }
  
  @Override
  public int handeln(ArrayList<HaendlerInterface> hand, EinUndAusgabe io){
      io.ausgeben("Spieler: " + this + "\n");
      io.ausgeben(" (0) beenden");
      for(int i = 0; i < hand.size(); i++) {
        io.ausgeben("\n (" + (i + 1) + ") handeln mit " 
            + hand.get(i));
      }
      io.ausgeben("  : ");
      int ein = io.leseInteger();
      if (ein > 0 && ein <= hand.size()) {
        this.handeln(hand.get(ein - 1), io);
      }
      return ein; 
  }
  
  public void handeln(HaendlerInterface h, EinUndAusgabe io) {
    Item geben = this.auswaehlen(io);
    if (geben != null) {
      this.items.remove(geben);
      this.items.addAll(h.handel(geben));
    }
  }
  
  private Item auswaehlen(EinUndAusgabe io) {
    io.ausgeben("Welches Item wollen Sie tauschen?");
    io.ausgeben("\n (0) abbrechen" );
    for(int i = 0; i < this.items.size(); i++) {
      io.ausgeben("\n (" + (i + 1) + ") " + this.items.get(i) );
    }
    io.ausgeben("  : ");
    int ein = io.leseInteger();
    if (ein < 1 || ein > this.items.size()) {
      return null;
    }
    Item ergebnis = this.items.get(ein - 1);
    return ergebnis;
  }
  
  public String getName() {
    return this.name;
  }
  
  @Override
  public String toString() {
    return this.name + ": " + this.items;
  }
}
