package entity;

import java.util.Objects;

public class Linie {

	private Punkt start;
	private Punkt ende;
	
	public Linie() {}

	public Linie(Punkt start, Punkt ende) {
		super();
		this.start = start;
		this.ende = ende;
	}
	
	public void verschieben(int dx, int dy) {
		this.start.verschieben(dx, dy);
		this.ende.verschieben(dx, dy);
	}

	public Punkt getStart() {
		return start;
	}

	public void setStart(Punkt start) {
		this.start = start;
	}

	public Punkt getEnde() {
		return ende;
	}

	public void setEnde(Punkt ende) {
		this.ende = ende;
	}

	@Override
	public int hashCode() {
		return Objects.hash(ende, start);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Linie other = (Linie) obj;
		return Objects.equals(ende, other.ende) && Objects.equals(start, other.start);
	}

	@Override
	public String toString() {
		return "Linie [start=" + start + ", ende=" + ende + "]";
	}
	
}
