package entity;

import java.util.Objects;

public class Punkt {

	private int x;
	private int y;
	
	public Punkt() {}

	public Punkt(int x, int y) {
		super();
		this.x = x;
		this.y = y;
	}

	public void verschieben(int dx, int dy) {
		this.x += dx;
		this.y += dy;
	}
	
	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	@Override
	public int hashCode() {
		return Objects.hash(x, y);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Punkt other = (Punkt) obj;
		return x == other.x && y == other.y;
	}

	@Override
	public String toString() {
		return "Punkt [x=" + x + ", y=" + y + "]";
	}
	
}
